<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Send Multiple Links</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f4f6f8;
            padding: 30px;
        }
        textarea {
            width: 100%;
            height: 200px;
            padding: 10px;
            font-size: 14px;
        }
        button {
            margin-top: 15px;
            padding: 10px 20px;
            font-size: 16px;
            cursor: pointer;
        }
    </style>
</head>
<body>

<h2>Open Multiple Links</h2>

<form method="post">
    <textarea name="links" placeholder="Enter one link per line..."></textarea>
    <br>
    <button type="submit" name="open">Send</button>
</form>

<?php
if (isset($_POST['open']) && !empty($_POST['links'])) {
    $links = explode("\n", trim($_POST['links']));

    echo "<script>";
    foreach ($links as $link) {
        $link = trim($link);
        if (filter_var($link, FILTER_VALIDATE_URL)) {
            echo "window.open('$link', '_blank');";
        }
    }
    echo "</script>";
}
?>

</body>
</html>
