<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Get parameters from URL (GET) or POST form
$mobile  = isset($_GET['mobile']) ? $_GET['mobile'] : (isset($_POST['mobile']) ? $_POST['mobile'] : '');
$message = isset($_GET['message']) ? $_GET['message'] : (isset($_POST['message']) ? $_POST['message'] : 'test message');

// If either parameter exists, send SMS
if (!empty($mobile) && !empty($message)) {

    $wsdl = "https://smsvas.vlserv.com/KannelSending/service.asmx?WSDL";

    $client = new SoapClient($wsdl, [
        "trace" => true,
        "exceptions" => true,
        "cache_wsdl" => WSDL_CACHE_NONE,
        "stream_context" => stream_context_create([
            'ssl' => [
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true
            ]
        ])
    ]);

    $params = [
        "UserName"    => "RoyalFC-API",
        "Password"    => "Ni1C9lmDC7",
        "SMSText"     => $message,
        "SMSLang"     => "e",
        "SMSSender"   => "Royal FC",
        "SMSReceiver" => $mobile
    ];

    try {
        $result = $client->SendSMS($params);
        $response = "<h3>SMS Sent Successfully</h3><pre>" . print_r($result, true) . "</pre>";
    } catch (SoapFault $fault) {
        $response = "<h3>SOAP Error:</h3><pre>Fault Code: {$fault->faultcode}<br>Fault String: {$fault->faultstring}</pre>";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>SMS Tester</title>
</head>
<body>

<h2>Send SMS Test</h2>

<form method="post">
    <label>Mobile Number:</label><br>
    <input type="text" name="mobile" value="<?php echo htmlspecialchars($mobile); ?>" required><br><br>

    <label>Message:</label><br>
    <textarea name="message" rows="4" cols="40" required><?php echo htmlspecialchars($message); ?></textarea><br><br>

    <button type="submit" name="send_sms">Send SMS</button>
</form>

<hr>

<?php
if (isset($response)) {
    echo $response;
}
?>

</body>
</html>
